REBOL [
	Subject: "Extraction des pices jointes"
	author: "Olivier Auverlot"
]

set-net [ 
	olivier@perspective.org 
	mail.perspective.org 
	mail.perspective.org
	none none none 
]

extraction: function [ bloc ] [ 
	boundary-value start-boundary-value
	b nom-fichier data
] [ 
	b: copy ""

	either (find (to-string bloc) "multipart") [
		parse bloc [
			thru "boundary=^""
				copy boundary-value
			to "^"^/"
		]
		insert head boundary-value "--"
		start-boundary-value: copy join boundary-value "^/"
		parse bloc [
			any [
				thru start-boundary-value
					copy b
				to boundary-value
				(extraction b)
			]
		]
	] [
		parse bloc [ thru "name=^"" copy b to "^"" ]
		if b <> "" [
			nom-fichier: to-file copy b
			data: copy ""
			parse bloc [ thru "^/^/" copy data to end ]
			either found? find bloc "base64" [
				insert data "64#{" append data "}" 
				write/binary nom-fichier (load data)
			] [ write/binary nom-fichier data ]
		]
	]
]

mail: read pop://olivier:homer@mail.perspective.org
foreach message mail [
	extraction message
]
input
